/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableSet;
import io.github.fabricators_of_create.porting_lib.common.util.PlantType;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1827;
import net.minecraft.class_1853;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2358;
import net.minecraft.class_2362;
import net.minecraft.class_2400;
import net.minecraft.class_2465;
import net.minecraft.class_2484;
import net.minecraft.class_2490;
import net.minecraft.class_2498;
import net.minecraft.class_2549;
import net.minecraft.class_2591;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.class_4048;
import net.minecraft.class_4651;
import net.minecraft.class_4970;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5585;
import net.minecraft.class_5586;
import net.minecraft.class_5587;
import net.minecraft.class_5589;
import net.minecraft.class_5843;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.BloodSlimeBlock;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.PiglinWallHeadBlock;
import slimeknights.tconstruct.world.block.SlimeDirtBlock;
import slimeknights.tconstruct.world.block.SlimeFungusBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeNyliumBlock;
import slimeknights.tconstruct.world.block.SlimeSaplingBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.block.SlimeWartBlock;
import slimeknights.tconstruct.world.block.StickySlimeBlock;
import slimeknights.tconstruct.world.data.WorldRecipeProvider;
import slimeknights.tconstruct.world.entity.EarthSlimeEntity;
import slimeknights.tconstruct.world.entity.EnderSlimeEntity;
import slimeknights.tconstruct.world.entity.SkySlimeEntity;
import slimeknights.tconstruct.world.entity.SlimePlacementPredicate;
import slimeknights.tconstruct.world.entity.TerracubeEntity;
import slimeknights.tconstruct.world.item.SlimeGrassSeedItem;
import slimeknights.tconstruct.world.worldgen.trees.SlimeTree;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;

public final class TinkerWorld
extends TinkerModule {
    static final Logger log = Util.getLogger("tinker_world");
    public static final PlantType SLIME_PLANT_TYPE = PlantType.get((String)"slime");
    private static final class_1792.class_1793 WORLD_PROPS = new class_1792.class_1793();
    private static final Function<class_2248, ? extends class_1747> DEFAULT_BLOCK_ITEM = b -> new class_1747(b, WORLD_PROPS);
    private static final Function<class_2248, ? extends class_1747> TOOLTIP_BLOCK_ITEM = b -> new BlockTooltipItem(b, WORLD_PROPS);
    private static final class_1792.class_1793 HEAD_PROPS = new class_1792.class_1793().method_7894(class_1814.field_8907);
    public static final ItemObject<class_2248> cobaltOre = BLOCKS.register("cobalt_ore", () -> new class_2248(TinkerWorld.builder(class_3620.field_16012, class_2498.field_22148).method_51368(class_2766.field_12653).method_29292().method_9632(10.0f)), DEFAULT_BLOCK_ITEM);
    public static final ItemObject<class_2248> rawCobaltBlock = BLOCKS.register("raw_cobalt_block", () -> new class_2248(TinkerWorld.builder(class_3620.field_15984, class_2498.field_22148).method_51368(class_2766.field_12653).method_29292().method_9629(6.0f, 7.0f)), DEFAULT_BLOCK_ITEM);
    public static final ItemObject<class_1792> rawCobalt = ITEMS.register("raw_cobalt", WORLD_PROPS);
    public static final EnumObject<SlimeType, class_2490> slime = Util.make(() -> {
        Function<SlimeType, class_4970.class_2251> slimeProps = type -> TinkerWorld.builder(type.getMapColor(), class_2498.field_11545).method_9628(0.8f).method_9626(class_2498.field_11545).method_22488();
        return new EnumObject.Builder(SlimeType.class).putDelegate((Enum)SlimeType.EARTH, (Object)((class_2490)class_2246.field_10030)).put((Enum)SlimeType.SKY, (Supplier)BLOCKS.register("sky_slime", () -> new StickySlimeBlock((class_4970.class_2251)slimeProps.apply(SlimeType.SKY), (state, other) -> true), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime", () -> new StickySlimeBlock(((class_4970.class_2251)slimeProps.apply(SlimeType.ICHOR)).method_9631(s -> SlimeType.ICHOR.getLightLevel()), (state, other) -> other.method_26204() != state.method_26204()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ENDER, (Supplier)BLOCKS.register("ender_slime", () -> new StickySlimeBlock((class_4970.class_2251)slimeProps.apply(SlimeType.ENDER), (state, other) -> other.method_26204() == state.method_26204()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime", () -> new BloodSlimeBlock((class_4970.class_2251)slimeProps.apply(SlimeType.BLOOD)), TOOLTIP_BLOCK_ITEM)).build();
    });
    public static final EnumObject<SlimeType, CongealedSlimeBlock> congealedSlime = BLOCKS.registerEnum(SlimeType.values(), "congealed_slime", type -> new CongealedSlimeBlock(TinkerWorld.builder(type.getMapColor(), class_2498.field_11545).method_9632(0.5f).method_9628(0.5f).method_9631(s -> type.getLightLevel())), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeType, class_2248> slimeDirt = Util.make(() -> {
        Function<SlimeType, class_3620> color = type -> switch (type) {
            default -> class_3620.field_15999;
            case SlimeType.SKY -> class_3620.field_25706;
            case SlimeType.ENDER -> class_3620.field_15991;
            case SlimeType.ICHOR -> class_3620.field_15981;
        };
        return BLOCKS.registerEnum(SlimeType.TRUE_SLIME, "slime_dirt", type -> new SlimeDirtBlock(TinkerWorld.builder((class_3620)color.apply((SlimeType)((Object)((Object)type))), class_2498.field_11545).method_9632(1.9f)), TOOLTIP_BLOCK_ITEM);
    });
    public static final EnumObject<SlimeType, class_2248> allDirt = new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.BLOOD, () -> class_2246.field_10566).putAll(slimeDirt).build();
    public static final EnumObject<SlimeType, class_2248> vanillaSlimeGrass;
    public static final EnumObject<SlimeType, class_2248> earthSlimeGrass;
    public static final EnumObject<SlimeType, class_2248> skySlimeGrass;
    public static final EnumObject<SlimeType, class_2248> enderSlimeGrass;
    public static final EnumObject<SlimeType, class_2248> ichorSlimeGrass;
    public static final Map<SlimeType, EnumObject<SlimeType, class_2248>> slimeGrass;
    public static final EnumObject<SlimeType, SlimeGrassSeedItem> slimeGrassSeeds;
    public static final WoodBlockObject greenheart;
    public static final WoodBlockObject skyroot;
    public static final WoodBlockObject bloodshroom;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeFern;
    public static final EnumObject<SlimeType, SlimeTallGrassBlock> slimeTallGrass;
    public static final EnumObject<SlimeType, class_2362> pottedSlimeFern;
    public static final EnumObject<SlimeType, class_2248> slimeSapling;
    public static final EnumObject<SlimeType, class_2362> pottedSlimeSapling;
    public static final EnumObject<SlimeType, class_2248> slimeLeaves;
    public static final ItemObject<SlimeVineBlock> skySlimeVine;
    public static final ItemObject<SlimeVineBlock> enderSlimeVine;
    public static final GeodeItemObject earthGeode;
    public static final class_5321<class_2975<?, ?>> configuredEarthGeodeKey;
    public static final class_5321<class_6796> placedEarthGeodeKey;
    public static final GeodeItemObject skyGeode;
    public static final class_5321<class_2975<?, ?>> configuredSkyGeodeKey;
    public static final class_5321<class_6796> placedSkyGeodeKey;
    public static final GeodeItemObject ichorGeode;
    public static final class_5321<class_2975<?, ?>> configuredIchorGeodeKey;
    public static final class_5321<class_6796> placedIchorGeodeKey;
    public static final GeodeItemObject enderGeode;
    public static final class_5321<class_2975<?, ?>> configuredEnderGeodeKey;
    public static final class_5321<class_6796> placedEnderGeodeKey;
    public static final EnumObject<TinkerHeadType, class_2484> heads;
    public static final EnumObject<TinkerHeadType, class_2549> wallHeads;
    public static final EnumObject<TinkerHeadType, class_1827> headItems;
    public static final RegistryObject<class_1299<EarthSlimeEntity>> earthSlimeEntity;
    public static final RegistryObject<class_1299<SkySlimeEntity>> skySlimeEntity;
    public static final RegistryObject<class_1299<EnderSlimeEntity>> enderSlimeEntity;
    public static final RegistryObject<class_1299<TerracubeEntity>> terracubeEntity;
    public static final RegistryObject<class_2400> skySlimeParticle;
    public static final RegistryObject<class_2400> enderSlimeParticle;
    public static final RegistryObject<class_2400> terracubeParticle;
    public static class_5321<class_2975<?, ?>> smallCobaltOreKey;
    public static class_5321<class_6796> placedSmallCobaltOreKey;
    public static class_5321<class_2975<?, ?>> largeCobaltOreKey;
    public static class_5321<class_6796> placedLargeCobaltOreKey;

    private static Function<WoodBlockObject.WoodVariant, class_4970.class_2251> createSlimewood(class_3620 planks, class_3620 bark) {
        return type -> switch (type) {
            case WoodBlockObject.WoodVariant.WOOD -> class_4970.class_2251.method_9637().method_31710(bark).method_9626(class_2498.field_11547).method_29292();
            case WoodBlockObject.WoodVariant.LOG -> class_4970.class_2251.method_9637().method_51520(state -> state.method_11654((class_2769)class_2465.field_11459) == class_2350.class_2351.field_11052 ? planks : bark).method_9626(class_2498.field_11547).method_29292();
            default -> class_4970.class_2251.method_9637().method_31710(planks).method_9626(class_2498.field_11545);
        };
    }

    public static class_5321<class_2975<?, ?>> configured(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)TConstruct.getResource(id));
    }

    public static class_5321<class_6796> placed(String id) {
        return class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)TConstruct.getResource(id));
    }

    public static void bootstrapConfigured(class_7891<class_2975<?, ?>> bootstapContext) {
        class_3819 netherrack = new class_3819(class_2246.field_10515);
        class_7871 lookup = bootstapContext.method_46799(class_7924.field_41239);
        class_6803.method_39708(bootstapContext, smallCobaltOreKey, (class_3031)class_3031.field_13517, (class_3037)new class_3124((class_3825)netherrack, ((class_2248)cobaltOre.get()).method_9564(), 4));
        class_6803.method_39708(bootstapContext, largeCobaltOreKey, (class_3031)class_3031.field_13517, (class_3037)new class_3124((class_3825)netherrack, ((class_2248)cobaltOre.get()).method_9564(), 6));
        TinkerWorld.configuredGeode(bootstapContext, configuredEarthGeodeKey, earthGeode, (class_4651)class_4651.method_38432((class_2248)class_2246.field_27114), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10460), new class_5587(1.7, 2.2, 3.2, 5.2), new class_5586(0.95, 2.0, 2), (class_6017)class_6019.method_35017((int)6, (int)9), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), 16, 1);
        TinkerWorld.configuredGeode(bootstapContext, configuredSkyGeodeKey, skyGeode, (class_4651)class_4651.method_38432((class_2248)class_2246.field_27114), (class_4651)class_4651.method_38432((class_2248)class_2246.field_9989), new class_5587(1.5, 2.0, 3.0, 4.5), new class_5586(0.55, 0.5, 2), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)1), 8, 3);
        TinkerWorld.configuredGeode(bootstapContext, configuredIchorGeodeKey, ichorGeode, (class_4651)class_4651.method_38432((class_2248)class_2246.field_27114), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10515), new class_5587(1.7, 2.2, 3.2, 4.2), new class_5586(0.75, 2.0, 2), (class_6017)class_6019.method_35017((int)4, (int)6), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), 24, 20);
        TinkerWorld.configuredGeode(bootstapContext, configuredEnderGeodeKey, enderGeode, (class_4651)class_4651.method_38432((class_2248)class_2246.field_27114), (class_4651)class_4651.method_38432((class_2248)class_2246.field_10471), new class_5587(1.7, 2.2, 3.2, 5.2), new class_5586(0.45, 1.0, 2), (class_6017)class_6019.method_35017((int)4, (int)10), (class_6017)class_6019.method_35017((int)3, (int)4), (class_6017)class_6019.method_35017((int)1, (int)2), 16, 10000);
        TinkerStructures.bootstrapConfigured(bootstapContext);
    }

    public static void bootstrap(class_7891<class_6796> bootstapContext) {
        class_7871 lookup = bootstapContext.method_46799(class_7924.field_41239);
        class_6817.method_40370(bootstapContext, placedSmallCobaltOreKey, (class_6880)lookup.method_46747(smallCobaltOreKey), (class_6797[])new class_6797[]{class_6793.method_39623((int)5), class_5450.method_39639(), class_6817.field_36084, class_6792.method_39614()});
        class_6817.method_40370(bootstapContext, placedLargeCobaltOreKey, (class_6880)lookup.method_46747(largeCobaltOreKey), (class_6797[])new class_6797[]{class_6793.method_39623((int)3), class_5450.method_39639(), class_6795.method_39637((class_5843)class_5843.method_33841((int)8), (class_5843)class_5843.method_33841((int)32)), class_6792.method_39614()});
        TinkerWorld.placedGeode(bootstapContext, placedEarthGeodeKey, lookup.method_46747(configuredEarthGeodeKey), class_6799.method_39659((int)128), class_6795.method_39634((class_5843)class_5843.method_33846((int)6), (class_5843)class_5843.method_33846((int)54)));
        TinkerWorld.placedGeode(bootstapContext, placedSkyGeodeKey, lookup.method_46747(configuredSkyGeodeKey), class_6799.method_39659((int)64), class_6795.method_39634((class_5843)class_5843.method_33841((int)16), (class_5843)class_5843.method_33841((int)54)));
        TinkerWorld.placedGeode(bootstapContext, placedIchorGeodeKey, lookup.method_46747(configuredIchorGeodeKey), class_6799.method_39659((int)52), class_6795.method_39634((class_5843)class_5843.method_33849((int)48), (class_5843)class_5843.method_33849((int)16)));
        TinkerWorld.placedGeode(bootstapContext, placedEnderGeodeKey, lookup.method_46747(configuredEnderGeodeKey), class_6799.method_39659((int)256), class_6795.method_39634((class_5843)class_5843.method_33846((int)16), (class_5843)class_5843.method_33846((int)64)));
    }

    public static void configuredGeode(class_7891<class_2975<?, ?>> bootstapContext, class_5321<class_2975<?, ?>> name, GeodeItemObject geode, class_4651 middleLayer, class_4651 outerLayer, class_5587 layerSettings, class_5586 crackSettings, class_6017 outerWall, class_6017 distributionPoints, class_6017 pointOffset, int genOffset, int invalidBlocks) {
        class_6803.method_39708(bootstapContext, name, (class_3031)class_3031.field_27312, (class_3037)new class_5589(new class_5585((class_4651)class_4651.method_38432((class_2248)class_2246.field_10124), (class_4651)class_4651.method_38432((class_2248)geode.getBlock()), (class_4651)SupplierBlockStateProvider.ofBlock(geode::getBudding), middleLayer, outerLayer, Arrays.stream(GeodeItemObject.BudSize.values()).map(type -> geode.getBud((GeodeItemObject.BudSize)((Object)type)).method_9564()).toList(), class_3481.field_33757, class_3481.field_33863), layerSettings, crackSettings, 0.335, 0.083, true, outerWall, distributionPoints, pointOffset, -genOffset, genOffset, 0.05, invalidBlocks));
    }

    public static void placedGeode(class_7891<class_6796> bootstapContext, class_5321<class_6796> name, class_6880<class_2975<?, ?>> geode, class_6799 rarity, class_6795 height) {
        class_6817.method_40370(bootstapContext, name, geode, (class_6797[])new class_6797[]{rarity, class_5450.method_39639(), height, class_6792.method_39614()});
    }

    public static void init() {
        TinkerWorld.entityAttributes();
        TinkerWorld.commonSetup();
    }

    public static void entityAttributes() {
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)earthSlimeEntity.get()), (class_5132.class_5133)class_1588.method_26918());
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)skySlimeEntity.get()), (class_5132.class_5133)class_1588.method_26918());
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)enderSlimeEntity.get()), (class_5132.class_5133)class_1588.method_26918());
        FabricDefaultAttributeRegistry.register((class_1299)((class_1299)terracubeEntity.get()), (class_5132.class_5133)class_1588.method_26918());
    }

    private static void setWoodFireInfo(class_2358 fireBlock, WoodBlockObject wood) {
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)wood.get(), 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)wood.getSlab(), 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)wood.getStairs(), 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)wood.getFence(), 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)wood.getFenceGate(), 5, 20);
        FlammableBlockRegistry.getDefaultInstance().add(wood.getLog(), 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(wood.getStrippedLog(), 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(wood.getWood(), 5, 5);
        FlammableBlockRegistry.getDefaultInstance().add(wood.getStrippedWood(), 5, 5);
    }

    public static void commonSetup() {
        class_1317.method_20637((class_1299)((class_1299)earthSlimeEntity.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, new SlimePlacementPredicate(TinkerTags.Blocks.EARTH_SLIME_SPAWN));
        class_1317.method_20637((class_1299)((class_1299)skySlimeEntity.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, new SlimePlacementPredicate(TinkerTags.Blocks.SKY_SLIME_SPAWN));
        class_1317.method_20637((class_1299)((class_1299)enderSlimeEntity.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, new SlimePlacementPredicate(TinkerTags.Blocks.ENDER_SLIME_SPAWN));
        class_1317.method_20637((class_1299)((class_1299)terracubeEntity.get()), (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, TerracubeEntity::canSpawnHere);
        slimeLeaves.forEach((type, block) -> CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(type.isNether() ? 0.85f : 0.35f)));
        slimeSapling.forEach(block -> CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.35f)));
        slimeTallGrass.forEach(block -> CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.35f)));
        slimeFern.forEach(block -> CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.65f)));
        slimeGrassSeeds.forEach(block -> CompostingChanceRegistry.INSTANCE.add((class_1935)block, (Object)Float.valueOf(0.35f)));
        CompostingChanceRegistry.INSTANCE.add(skySlimeVine, (Object)Float.valueOf(0.5f));
        CompostingChanceRegistry.INSTANCE.add(enderSlimeVine, (Object)Float.valueOf(0.5f));
        class_2969 dispenseArmor = new class_2969(){

            protected class_1799 method_10135(class_2342 source, class_1799 stack) {
                this.method_27955(class_1738.method_7684((class_2342)source, (class_1799)stack));
                return stack;
            }
        };
        heads.forEach(arg_0 -> TinkerWorld.lambda$commonSetup$53((class_2357)dispenseArmor, arg_0));
        heads.forEach(head -> class_1853.field_9013.put(head.method_8389(), class_1781.class_1782.field_7974));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)class_2591.field_11913.field_19315);
        heads.forEach(head -> builder.add(head));
        wallHeads.forEach(head -> builder.add(head));
        class_2591.field_11913.field_19315 = builder.build();
        class_2358 fireblock = (class_2358)class_2246.field_10036;
        BiConsumer<SlimeType, class_2248> plantFireInfo = (type, block) -> {
            if (type != SlimeType.BLOOD && type != SlimeType.ICHOR) {
                fireblock.method_10189(block, 30, 60);
            }
        };
        slimeLeaves.forEach(plantFireInfo);
        slimeTallGrass.forEach(plantFireInfo);
        slimeFern.forEach(plantFireInfo);
        fireblock.method_10189((class_2248)skySlimeVine.get(), 15, 100);
        fireblock.method_10189((class_2248)enderSlimeVine.get(), 15, 100);
    }

    public static void gatherData(FabricDataGenerator.Pack pack) {
        pack.addProvider(WorldRecipeProvider::new);
    }

    private static class_2484 makeHead(TinkerHeadType type) {
        class_4970.class_2251 props = class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9632(1.0f);
        return new class_2484((class_2484.class_2485)type, props);
    }

    private static class_2549 makeWallHead(TinkerHeadType type) {
        class_4970.class_2251 props = class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9632(1.0f).method_16228((class_2248)heads.get((Enum)type));
        if (type == TinkerHeadType.PIGLIN_BRUTE || type == TinkerHeadType.ZOMBIFIED_PIGLIN) {
            return new PiglinWallHeadBlock(type, props);
        }
        return new class_2549((class_2484.class_2485)type, props);
    }

    private static /* synthetic */ void lambda$commonSetup$53(class_2357 dispenseArmor, class_2484 head) {
        class_2315.method_10009((class_1935)head, (class_2357)dispenseArmor);
    }

    static {
        slimeGrass = new EnumMap<SlimeType, EnumObject<SlimeType, class_2248>>(SlimeType.class);
        Function<SlimeType, class_4970.class_2251> slimeGrassProps = type -> TinkerWorld.builder(type.getMapColor(), class_2498.field_11545).method_9632(2.0f).method_29292().method_9640();
        Function<SlimeType, class_2248> slimeGrassRegister = type -> type.isNether() ? new SlimeNyliumBlock((class_4970.class_2251)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)) : new SlimeGrassBlock((class_4970.class_2251)slimeGrassProps.apply((SlimeType)((Object)type)), (SlimeType)((Object)type));
        vanillaSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "vanilla_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        earthSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "earth_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        skySlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "sky_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        enderSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ender_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        ichorSlimeGrass = BLOCKS.registerEnum(SlimeType.values(), "ichor_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        slimeGrass.put(SlimeType.BLOOD, vanillaSlimeGrass);
        slimeGrass.put(SlimeType.EARTH, earthSlimeGrass);
        slimeGrass.put(SlimeType.SKY, skySlimeGrass);
        slimeGrass.put(SlimeType.ENDER, enderSlimeGrass);
        slimeGrass.put(SlimeType.ICHOR, ichorSlimeGrass);
        slimeGrassSeeds = ITEMS.registerEnum(SlimeType.values(), "slime_grass_seeds", type -> new SlimeGrassSeedItem(WORLD_PROPS, (SlimeType)((Object)type)));
        greenheart = BLOCKS.registerWood("greenheart", TinkerWorld.createSlimewood(class_3620.field_15997, class_3620.field_15995), false);
        skyroot = BLOCKS.registerWood("skyroot", TinkerWorld.createSlimewood(class_3620.field_16026, class_3620.field_15990), false);
        bloodshroom = BLOCKS.registerWood("bloodshroom", TinkerWorld.createSlimewood(class_3620.field_16020, class_3620.field_15987), false);
        Function<SlimeType, class_4970.class_2251> props = type -> {
            class_4970.class_2251 properties = type.isNether() ? TinkerWorld.builder(type.getMapColor(), class_2498.field_22138).method_51371().method_50012(class_3619.field_15971) : TinkerWorld.builder(type.getMapColor(), class_2498.field_11535).method_51371().method_50013().method_50012(class_3619.field_15971);
            return properties.method_9618().method_9634();
        };
        slimeFern = BLOCKS.registerEnum(SlimeType.values(), "slime_fern", type -> new SlimeTallGrassBlock((class_4970.class_2251)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        slimeTallGrass = BLOCKS.registerEnum(SlimeType.values(), "slime_tall_grass", type -> new SlimeTallGrassBlock((class_4970.class_2251)props.apply((SlimeType)((Object)type)), (SlimeType)((Object)type)), DEFAULT_BLOCK_ITEM);
        pottedSlimeFern = BLOCKS.registerPottedEnum(SlimeType.values(), "slime_fern", slimeFern);
        slimeSapling = Util.make(() -> {
            Function<SlimeType, class_4970.class_2251> props = type -> TinkerWorld.builder(type.getMapColor(), type.isNether() ? class_2498.field_22154 : class_2498.field_11535).method_50012(class_3619.field_15971).method_9618().method_9634();
            return new EnumObject.Builder(SlimeType.class).putAll(BLOCKS.registerEnum(SlimeType.OVERWORLD, "slime_sapling", type -> new SlimeSaplingBlock(new SlimeTree((SlimeType)((Object)((Object)type))), (SlimeType)((Object)((Object)type)), ((class_4970.class_2251)props.apply((SlimeType)((Object)((Object)type)))).method_9640()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.BLOOD, (Supplier)BLOCKS.register("blood_slime_sapling", () -> new SlimeFungusBlock((class_4970.class_2251)props.apply(SlimeType.BLOOD), class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)TConstruct.getResource("blood_slime_fungus"))), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime_sapling", () -> new SlimeFungusBlock((class_4970.class_2251)props.apply(SlimeType.ICHOR), class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)TConstruct.getResource("ichor_slime_fungus"))), HIDDEN_BLOCK_ITEM)).build();
        });
        pottedSlimeSapling = BLOCKS.registerPottedEnum(SlimeType.values(), "slime_sapling", slimeSapling);
        slimeLeaves = BLOCKS.registerEnum(SlimeType.values(), "slime_leaves", type -> {
            if (type.isNether()) {
                return new SlimeWartBlock(TinkerWorld.builder(type.getMapColor(), class_2498.field_22144).method_9632(1.5f).method_26235((s, w, p, e) -> false), (SlimeType)((Object)type));
            }
            return new SlimeLeavesBlock(TinkerWorld.builder(type.getMapColor(), class_2498.field_11535).method_50013().method_50012(class_3619.field_15971).method_9632(1.0f).method_9640().method_22488().method_26235((s, w, p, e) -> false), (SlimeType)((Object)type));
        }, DEFAULT_BLOCK_ITEM);
        props = type -> TinkerWorld.builder(type.getMapColor(), class_2498.field_11535).method_51371().method_50013().method_50012(class_3619.field_15971).method_9632(0.75f).method_9634().method_9640();
        skySlimeVine = BLOCKS.register("sky_slime_vine", () -> new SlimeVineBlock((class_4970.class_2251)props.apply(SlimeType.SKY), SlimeType.SKY), DEFAULT_BLOCK_ITEM);
        enderSlimeVine = BLOCKS.register("ender_slime_vine", () -> new SlimeVineBlock((class_4970.class_2251)props.apply(SlimeType.ENDER), SlimeType.ENDER), DEFAULT_BLOCK_ITEM);
        earthGeode = BLOCKS.registerGeode("earth_slime_crystal", class_3620.field_15997, Sounds.EARTH_CRYSTAL, Sounds.EARTH_CRYSTAL_CHIME.getSound(), Sounds.EARTH_CRYSTAL_CLUSTER, 3, WORLD_PROPS);
        configuredEarthGeodeKey = TinkerWorld.configured("earth_geode");
        placedEarthGeodeKey = TinkerWorld.placed("earth_geode");
        skyGeode = BLOCKS.registerGeode("sky_slime_crystal", class_3620.field_15984, Sounds.SKY_CRYSTAL, Sounds.SKY_CRYSTAL_CHIME.getSound(), Sounds.SKY_CRYSTAL_CLUSTER, 0, WORLD_PROPS);
        configuredSkyGeodeKey = TinkerWorld.configured("sky_geode");
        placedSkyGeodeKey = TinkerWorld.placed("sky_geode");
        ichorGeode = BLOCKS.registerGeode("ichor_slime_crystal", class_3620.field_15987, Sounds.ICHOR_CRYSTAL, Sounds.ICHOR_CRYSTAL_CHIME.getSound(), Sounds.ICHOR_CRYSTAL_CLUSTER, 10, WORLD_PROPS);
        configuredIchorGeodeKey = TinkerWorld.configured("ichor_geode");
        placedIchorGeodeKey = TinkerWorld.placed("ichor_geode");
        enderGeode = BLOCKS.registerGeode("ender_slime_crystal", class_3620.field_16014, Sounds.ENDER_CRYSTAL, Sounds.ENDER_CRYSTAL_CHIME.getSound(), Sounds.ENDER_CRYSTAL_CLUSTER, 7, WORLD_PROPS);
        configuredEnderGeodeKey = TinkerWorld.configured("ender_geode");
        placedEnderGeodeKey = TinkerWorld.placed("ender_geode");
        heads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "head", TinkerWorld::makeHead);
        wallHeads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "wall_head", TinkerWorld::makeWallHead);
        headItems = ITEMS.registerEnum(TinkerHeadType.values(), "head", type -> new class_1827((class_2248)heads.get((Enum)type), (class_2248)wallHeads.get((Enum)type), HEAD_PROPS, class_2350.field_11033));
        earthSlimeEntity = ENTITIES.registerWithEgg("earth_slime", () -> FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, EarthSlimeEntity::new).forceTrackedVelocityUpdates(true).trackRangeChunks(10).dimensions(class_4048.method_18384((float)2.04f, (float)2.04f)), 5349438, 8306542);
        skySlimeEntity = ENTITIES.registerWithEgg("sky_slime", () -> FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, SkySlimeEntity::new).forceTrackedVelocityUpdates(true).trackRangeChunks(20).dimensions(class_4048.method_18384((float)2.04f, (float)2.04f)), 4714485, 11337716);
        enderSlimeEntity = ENTITIES.registerWithEgg("ender_slime", () -> FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, EnderSlimeEntity::new).forceTrackedVelocityUpdates(true).trackRangeChunks(32).dimensions(class_4048.method_18384((float)2.04f, (float)2.04f)), 6488240, 13860095);
        terracubeEntity = ENTITIES.registerWithEgg("terracube", () -> FabricEntityTypeBuilder.create((class_1311)class_1311.field_6302, TerracubeEntity::new).forceTrackedVelocityUpdates(true).trackRangeChunks(8).dimensions(class_4048.method_18384((float)2.04f, (float)2.04f)), 11516374, 10594225);
        skySlimeParticle = PARTICLE_TYPES.register("sky_slime", () -> FabricParticleTypes.simple((boolean)false));
        enderSlimeParticle = PARTICLE_TYPES.register("ender_slime", () -> FabricParticleTypes.simple((boolean)false));
        terracubeParticle = PARTICLE_TYPES.register("terracube", () -> FabricParticleTypes.simple((boolean)false));
        smallCobaltOreKey = TinkerWorld.configured("cobalt_ore_small");
        placedSmallCobaltOreKey = TinkerWorld.placed("cobalt_ore_small");
        largeCobaltOreKey = TinkerWorld.configured("cobalt_ore_large");
        placedLargeCobaltOreKey = TinkerWorld.placed("cobalt_ore_large");
    }
}

